/*
 * Routines for logging
 */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "libfma.h"

#include "fma.h"

/*
 * Log a message
 */
void
fma_log(
  const char *fmt,
  ...)
{
  va_list args;
  int n;
  char *p = NULL;
  int size = LF_STRING_LEN;
  int tries = 0;

  LF_CALLOC(p, char, size);

  while (tries++ < 2) {
    va_start (args, fmt);
    n = vsnprintf (p, size, fmt, args);
    va_end (args);

    if (n > -1 && n < size) {
      break;
    } else {
      /* try again with more space */
      size *= 2;
      p = realloc(p, size);   /* times 2 for power of 2 style mallocs */
      if (p  == NULL) {
	LF_ERROR(("Error reallocing print buffer"));
      }
    }
  }

  /* print the msg with a timestamp */
  printf("%s %s\n", lf_timestamp(), p);

  LF_FREE(p);
  return;

 except:
  fma_perror_exit(1);
}
